@extends('layouts.app')

@section('content')
<div class="app">
    <div class="authentication">
        <div class="sign-in-2">
            <div class="container-fluid no-pdd-horizon bg">
                <div class="row">
                    <div class="col-md-10 mr-auto ml-auto">
                        <div class="row">
                            <div class="mr-auto ml-auto full-height height-100">
                                <div class="vertical-align full-height">
                                    <div class="table-cell">
                                        <div class="card">
                                            <div class="card-body">
                                                <div class="pdd-horizon-30 pdd-vertical-30">
                                                    <div class="mrg-btm-30">
                                                        <img class="img-responsive inline-block" src="{{asset('admin/dist/assets/images/logo.png')}}" alt="" style="width: 150px">
                                                        <h2 class="inline-block pull-right no-mrg-vertical pdd-top-15">Ingresar</h2>
                                                    </div>
                                                    @if(Session::has('delegado'))
                                                        <div class="row">
                                                            <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12 col-lg-offset-2 col-md-offset-2">
                                                                <p class="text-danger">
                                                                    {{Session::get('delegado') }}
                                                                </p>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <form class="ng-pristine ng-valid" method="post" action="{{ route('login') }}">
                                                        {{ csrf_field() }}
                                                        <div class="form-group">
                                                            <input type="email" class="form-control" placeholder="Email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                                        </div>
                                                        <div class="form-group">
                                                            <input type="password" class="form-control" placeholder="Password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">
                                                        </div>
                                                        <div class="checkbox font-size-13 inline-block no-mrg-vertical no-pdd-vertical">
                                                            <input id="agreement" name="remember" {{ old('remember') ? 'checked' : '' }} type="checkbox">
                                                            <label for="agreement">Recordar</label>
                                                        </div>
                                                        <div class="mrg-top-20 text-right">
                                                            <button class="btn btn-info">Login</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
