<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateJugadoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('jugadores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('id_equipo');
            $table->unsignedBigInteger('estado')->default(0);
            $table->string('nombres');
            $table->string('apellidos');
            $table->string('dni');
            $table->string('imagen')->nullable();
            $table->integer('impresiones')->default(0);
            $table->string('uuid')->nullable();
            $table->text('motivoCancelado')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('jugadores');
    }
}
