<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Posicion extends Model
{
	protected $table    = "posiciones";
	protected $fillable = ['equipo','jj','jg','jp','je','suma','gf','gc'];

    public static function cargaApi($id, $data)
    {
    	return static::updateOrCreate(['equipo'=> $id], $data);
    }

    public static function tablaSabatina($grupo)
    {
    	return static::select("posiciones.*", \DB::raw("equipos.nombre as nombreEquipo"))
    		->join("juegos", "juegos.equipo", "=", "posiciones.equipo")
            ->join("equipos", "equipos.idApi", "=", "posiciones.equipo")
    		->where("equipos.estado", "=", "E")
            ->where("equipos.nombre", "!=", "Bye")
            ->where(function($q) {
                $q->where('equipos.liga', "=", 1)
                ->orWhere('juegos.liga', "=", 1);
            })
            ->where(function($q) use ($grupo) {
                $q->where('equipos.grupo', "=", $grupo)
                ->orWhere('juegos.grupo', "=", $grupo);
            })
            ->groupBy("juegos.equipo")
    		->orderBy("posiciones.suma", "DESC")
            ->orderBy("posiciones.jg", "DESC")
            ->orderBy("posiciones.gf", "DESC")
    		->get();
    }

    public static function ligaDominical($grupo)
    {
        return static::select("posiciones.*", \DB::raw("equipos.nombre as nombreEquipo"))
            ->join("juegos", "juegos.equipo", "=", "posiciones.equipo")
            ->join("equipos", "equipos.idApi", "=", "posiciones.equipo")
            ->where("equipos.estado", "=", "E")
            ->where("equipos.nombre", "!=", "Bye")
            ->where(function($q) {
                $q->where('equipos.liga', "=", 2)
                ->orWhere('juegos.liga', "=", 2);
            })
            ->where(function($q) use ($grupo) {
                $q->where('equipos.grupo', "=", $grupo)
                ->orWhere('juegos.grupo', "=", $grupo);
            })
            ->groupBy("juegos.equipo")
            ->orderBy("posiciones.suma", "DESC")
            ->orderBy("posiciones.jg", "DESC")
            ->orderBy("posiciones.gf", "DESC")
            ->get();
    }

    public static function truncateTbPosicion()
    {
        $juegos = static::truncate();
        return true;
    }
}
