<?php

namespace App\Http\Controllers\front;

use Theme;
use App\Juego;
use App\Multa;
use App\Posicion;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class LigasController extends Controller
{
	public function __construct()
    {
    	Theme::init("deportivo");
    }

    public function sabatina($grupo, $jornada = false)
    {
        if ($jornada > 21) {
            return redirect()->to('/');
        }
        $jornadas = Juego::jornadasSabatinas($grupo);

        if (count($jornadas)>0) {
            $fecha = $jornadas[$jornada]->fecha;
        }else{
            $fecha = false;
        }

        if ($jornada === false) {
            foreach ($jornadas as $key => $value) {
                if (date("Y-m-d") >= $value->fecha) {
                    $fecha   = $value->fecha;
                    $jornada = $key;
                }
            }
        }

        $juegosSabatinos = Juego::juegosSabatinos($grupo, $fecha);
    	$posiciones      = Posicion::tablaSabatina($grupo);

        $equipos = [];
        foreach ($juegosSabatinos as $key => $value) {
            $equipos[] = $value->equipo;
        }

        $multas = Multa::select("jugadores.*", \DB::raw("equipos.nombre as equipo"))
            ->join("jugadores", "jugadores.id", "=", "multas.idJugador")
            ->join("equipos", "equipos.idApi", "=", "jugadores.id_equipo")
            ->where("multas.fecha", "=", $fecha)
            ->whereIn("idEquipo", $equipos)
            ->get();

        return View("front.ligaSabatina")->with(compact("posiciones", "grupo", "juegosSabatinos", "jornada", "multas"));
    }

    public function dominical($grupo, $jornada = false)
    {
        if ($jornada > 21) {
            return redirect()->to('/');
        }
        $jornadas  = Juego::jornadasDominical($grupo);

        if (count($jornadas)>0) {
            $fecha = $jornadas[$jornada]->fecha;
        }else{
            $fecha = false;
        }

        if ($jornada === false) {
            foreach ($jornadas as $key => $value) {
                if (date("Y-m-d") >= $value->fecha) {
                    $fecha   = $value->fecha;
                    $jornada = $key;
                }
            }
        }

        $juegosDominical = Juego::juegosDominical($grupo, $fecha);
    	$posiciones      = Posicion::ligaDominical($grupo);

        $equipos = [];
        foreach ($juegosDominical as $key => $value) {
            $equipos[] = $value->equipo;
        }

        $multas = Multa::select("jugadores.*", \DB::raw("equipos.nombre as equipo"))
            ->join("jugadores", "jugadores.id", "=", "multas.idJugador")
            ->join("equipos", "equipos.idApi", "=", "jugadores.id_equipo")
            ->where("multas.fecha", "=", $fecha)
            ->whereIn("idEquipo", $equipos)
            ->get();

        return View("front.ligaDominical")->with(compact("posiciones", "grupo", "juegosDominical", "jornada", "multas"));
    }
}
