<?php

namespace App\Http\Controllers\Admin;

use Hash;
use Theme;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class UsuarioController extends Controller
{
	public function __construct()
    {
    	Theme::init("adminmorelos");
    }

	public function index()
	{
		$usuarios=User::orderBy('rol', 'asc')->get();
		return view('usuarios/lista')->with(compact('usuarios'));
	}

	public function crear()
	{
		return view('usuarios/crear');
	}

	public function guardar(Request $request)
	{
		$usuario=new User;
		$usuario->nombre=$request->nombre;
		$usuario->email=$request->email;
		$usuario->password=Hash::make($request->password);
		$usuario->rol=$request->rol;
		try {
			$usuario->save();
			return redirect()->back()->with("success", "Datos Guardados");
		} catch (\Illuminate\Database\QueryException $e) {
			if($e->getCode()==23000){
				return redirect()->back()->withInput()->with("error", "Usuario duplicado");
			}else{
				return redirect()->back()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
			}
		}
	}

	public function editar($id)
	{
		$usuarios = User::findOrFail($id);
		return view('usuarios/editar',compact('usuarios'));
	}

	public function actualizar(Request $request,$id)
	{
		$usuario = User::findOrFail($id);
		$usuario->nombre=$request->nombre;
		$usuario->email=$request->email;
		$usuario->rol=$request->rol;
		try {
			$usuario->update();
			return redirect()->back()->with("success", "Datos Modificados");
		} catch (\Illuminate\Database\QueryException $e) {
			if($e->getCode()==23000){
				return redirect()->back()->withInput()->with("error", "Usuario duplicado");
			}else{
				return redirect()->back()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
			}
		}
	}

    public function borrar($id)
	{
		$user = User::findOrFail($id);
       
		return view('usuarios/borrar')->with(compact('user'));
	}


	public function eliminar($id)
	{
		$user = User::findOrFail($id);
		$user->delete();
		return redirect()->to('admin-morelos/usuarios');
	}

}
