<?php

namespace App\Http\Controllers\Admin;


use PDF;
use Theme;
use Response;
use App\User;
use App\Equipo;
use App\Jugador;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class EquipoController extends Controller
{
	public function __construct()
    {
    	Theme::init("adminmorelos");
    }

	public function index()
	{
		$equipos=Equipo::join('users', 'users.id', '=', 'equipos.id_usuario')
			->select('equipos.id', 'equipos.liga', 'equipos.nombre', 'equipos.logo', DB::raw('users.nombre as responsable'))
			->orderBy('id', 'ASC')
			->orderBy('liga', 'ASC')
			->paginate(25);
		return View('equipos/lista')->with(compact("equipos"));
	}

	public function imprimirCredencial()
	{
		$jugadores = DB::table('jugadores as a')
         	->select('a.id','a.nombres','a.apellidos','a.dni','a.imagen','a.created_at','a.impresiones')
         	->where('a.estado','=', 1)
         	->orderby('created_at','ASC')
         	->get();

		return View('equipos/listaJugadores')->with(compact("jugadores"));
	}

	public function generarCredencial($id)
	{
	    $jugador = Jugador::select('jugadores.id','jugadores.nombres','jugadores.apellidos','jugadores.dni','jugadores.imagen','equipos.nombre')->join("equipos", 'jugadores.id_equipo', '=', 'equipos.id')->where('jugadores.id', '=', $id)->first();
	    if ($jugador->imagen == null) {
	    	redirect()->back()->with("error", "el jugador debe tener una imagen");
	    }

	    $uuid = Str::uuid()->toString();

	    $jugador->impresiones = $jugador->impresiones + 1;
	    $jugador->uuid = $uuid;

	    $jugador->save();

	    return View('equipos/credencial')->with(compact("jugador", "uuid"));
	}

	public function generateC($id)
	{
		$jugador = Jugador::select('jugadores.id','jugadores.nombres','jugadores.apellidos','jugadores.dni','jugadores.imagen','equipos.nombre')->join("equipos", 'jugadores.id_equipo', '=', 'equipos.id')->where('jugadores.id', '=', $id)->first();
	    if ($jugador->imagen == null) {
	    	return redirect()->back()->with("error", "El jugador debe tener una imagen");
	    }

	    $time = time();

	    $conv = new \Anam\PhantomMagick\Converter();
	    $conv->setBinary(base_path().'\vendor\anam\phantomjs-linux-x86-binary\bin/phantomjs');
	    $options = [
		  'width' => '307',
		  'height'=> '192',
		  'quality' => 100
		];
	    $conv->setImageOptions($options);

		$conv->source(url('admin-morelos/equipos/generarCredencial/'.$id))
		    ->toJpg()
		    ->download($time.'credencial.jpg');

		//echo json_encode($conv);exit();

		/*$request = \PhantomJs::createImage(url('admin-morelos/equipos/generarCredencial/'.$id), 'GET');
		$request->setOutputFile($time.'credencial.jpg');
		$request->setViewportSize(307, 192);
		$request->setCaptureDimensions(307, 192, 0, 0);
		$response = \PhantomJs::send($request);
		if($response->getStatus() === 200) {
		    echo $response->getContent();
		    echo "<br><br>";
		    echo "<a href='".url('/admin-morelos/equipos/descargar/'.$time)."' style='font-weight:bold; font-size:14px; padding-left:10px'>Descargar</a>";
		}*/
	}

	public function lista()
	{
		$respuesta = ["data"=>false];
		$equipos=Equipo::join('users', 'users.id', '=', 'equipos.id_usuario')
			->select('equipos.liga', 'equipos.nombre', DB::raw('CONCAT(equipos.id, "/", equipos.logo) as DT_RowId'), DB::raw('users.nombre as responsable'), DB::raw('CONCAT("row_", equipos.id) as DT_RowId'))
			->orderBy('liga', 'ASC')
			->get()
    		->toJson();

    	if ($equipos) {
            $respuesta["data"] = json_decode($equipos);
        }

		return $respuesta;
	}

	public function descargar($time)
	{
		$filepath = public_path()."/".$time."credencial.jpg";
		return Response::download($filepath);
	}

	public function marcar($id)
	{
	    $jugador = Jugador::find($id);
	    $jugador->impresiones = $jugador->impresiones + 1;
	    $jugador->motivoCancelado = NULL;
	    $jugador->estado = 0;
	    $jugador->save();
	    return redirect()->back()->with("success", "Credencial marcado como impreso");
	}

	public function marcarCancelado(Request $request)
	{
	    $jugador                  = Jugador::find($request->idJugador);
	    $jugador->motivoCancelado = $request->motivoCancelado;
	    $jugador->estado          = 0;
	    $jugador->save();
	    return ["error" => false, "mensaje"=>"Credencial marcado como cancelado"];
	}

	public function editar($id)
	{
		$equipo = Equipo::findOrFail($id);
		$usuarios=User::where('rol', '=', 'Delegado')->pluck('nombre', 'id');
		$logo = DB::table('equipos')
					->select('logo','id')
					->where('id','=',$id)
					->get();
		return View('equipos/editar')->with(compact('equipo','usuarios','logo'));
	}

	public function actualizar(Request $request,$id)
	{
		if(! is_null($request->logo)) {
			$equipo = Equipo::findOrFail($id);
			$imagen=$request->file('logo');
			$nombre_imagen=$imagen->getClientOriginalName();
			$equipo->id_usuario=$request->responsable;
			$equipo->nombre=$request->nombre;
			$equipo->liga=$request->liga;
			$equipo->grupo=$request->grupo;
			$equipo->logo=$nombre_imagen;
			DB::beginTransaction();
			try {
				if ($equipo->update()) {
					\Storage::disk('public')->put('equipos/'.$equipo->id."/".$nombre_imagen,  \File::get($imagen));
				}
				DB::commit();
				return redirect()->back()->with("success", "Datos Modificados");
			} catch (\Illuminate\Database\QueryException $e) {
				DB::rollback();
				if($e->getCode()==23000){
					return redirect()->back()->withInput()->with("error", "Equipo duplicado");
				}else{
					return redirect()->back()->withInput()->with("error", "Ocurrio un error, intenta de nuevo, si el problema persiste contacta con el proveedor");
				}
			} catch (\Exception $ex){
			DB::rollback();
				return redirect()->back()->withInput()->with("error", "Error al cargar imagen");
			}
		} else {
			$equipo = Equipo::findOrFail($id);
			$equipo->id_usuario=$request->responsable;
			$equipo->nombre=$request->nombre;
			$equipo->liga=$request->liga;
			$equipo->grupo=$request->grupo;
			$equipo->update();
			return redirect()->back()->with("success", "Datos Modificados");
		}
	}

	public function multas()
	{
        $jugadores = Jugador::with('equipo', 'multas')->get();
        // dd($jugadores);
	    return View('equipos/multas', compact('jugadores'));
	}
}
