<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Equipo extends Model
{
	protected $fillable   = ['nombre','liga','grupo','estado','idApi'];

    public static function cargaApi($id, $data)
    {
    	return static::updateOrCreate(['idApi'=> $id], $data);
    }

    public static function logosHome(){
    	return static::select('logo', 'id')
            ->inRandomOrder()
            ->limit(8)
            ->get();
    }
}
